# Contributing

This project accepts community contributions. In order to contribute, please:

1. Follow the coding style guidelines below
2. Agree to the Developer Certificate of Origin
3. Submit a GitHub pull request (PR) for review

## Coding Style

Please make sure to follow the general [Postgres coding conventions](https://www.postgresql.org/docs/16/source.html)
before submitting a PR.

## Developer Certificate of Origin

By contributing a PR to this project you agree to the [Developer Certificate of Origin (DCO)](https://developercertificate.org/).

This ensures that you can make the contribution and that the project has the
right to distribute your contribution under the terms of the project's
[LICENSE](LICENSE). The PR itself is a sign-off of your agreement to the DCO.

## Submission

Submit a PR against the `main` branch. Please include one of the following
prefixes in your commit messages so the [CHANGELOG](CHANGELOG.md) can be updated
automatically:

* `feat:` Adds a new feature
* `fix:` Fixes a bug in the code
* `refactor:` Restructures the code without changing its external behavior
* `docs:` Documentation only changes
* `test:` Adds or modifies tests
* `style:` Changes to whitespace, formatting, etc; no code changes
* `chore:` Changes to the build process or auxiliary tools
