CREATE EXTENSION IF NOT EXISTS pg_search;

CALL paradedb.create_bm25_test_table(
  schema_name => 'public',
  table_name => 'mock_items_issue_2528'
);
CREATE INDEX search_idx_issue_2528 ON mock_items_issue_2528 USING bm25 (id, description, category) WITH (key_field='id');


--
-- a table named "regress"."mock_items" with all fields indexed, including one as an expression
-- that all tests can use.
--
-- we add a new column, "sku", to the table, and populate it with a unique UUID per row
--
CREATE SCHEMA IF NOT EXISTS regress;
CALL paradedb.create_bm25_test_table(
        schema_name => 'regress',
        table_name => 'mock_items'
     );
ALTER TABLE regress.mock_items ADD COLUMN sku UUID;
UPDATE regress.mock_items SET sku = ('da2fea21-' || lpad(to_hex( id::int4), 4, '0') || '-411b-9e8c-2cb64e471293')::uuid;
VACUUM FULL regress.mock_items;
CREATE INDEX idxregress_mock_items
    ON regress.mock_items
        USING bm25 (id, sku, description, (lower(description)::pdb.simple('alias=description_lower')), rating, category, in_stock, metadata, created_at, last_updated_date, latest_available_time, weight_range)
    WITH (key_field='id');


/*
 raises an ERROR if a is distinct from b, displaying only the message
 */
CREATE FUNCTION assert(a anyelement, b anyelement, message text DEFAULT '') RETURNS bool LANGUAGE plpgsql AS $$
DECLARE
BEGIN
    IF a IS DISTINCT FROM b THEN
        RAISE EXCEPTION '%', message;
    END IF;
    RETURN true;
END;
$$;

/*
 raises an ERROR if a is distinct from b, displaying the values of a, b, and message
 */
CREATE FUNCTION assert_verbose(a anyelement, b anyelement, message text DEFAULT '') RETURNS bool LANGUAGE plpgsql AS $$
DECLARE
BEGIN
    IF a IS DISTINCT FROM b THEN
        RAISE EXCEPTION '% <> %: %', coalesce(a, '<NULL>'), coalesce(b, '<NULL>'), message;
    END IF;
    RETURN true;
END;
$$;
