CREATE EXTENSION IF NOT EXISTS pg_search;

CALL paradedb.create_bm25_test_table(
  schema_name => 'public',
  table_name => 'mock_items'
);

CREATE INDEX search_idx ON mock_items
USING bm25 (id, description, category, rating, in_stock, created_at, metadata, weight_range)
WITH (key_field='id', text_fields='{"description": {"unknown": "value", "tokenizer": {"type": "keyword"}}}');

SELECT description, rating, category
FROM mock_items
WHERE id @@@ paradedb.term('description', 'Sleek running shoes')
LIMIT 5;

DROP TABLE mock_items;
