drop table if exists test_phrase_table cascade;

CREATE TABLE test_phrase_table (
   id SERIAL PRIMARY KEY,
   flavour TEXT
);
INSERT INTO test_phrase_table (flavour) VALUES
    ('apple, with, banana'),
    ('Banana with Cherry'),
    ('Cherry, strawberry'),
    ('apple, cherry, banana');


CREATE INDEX test_phrase_index ON test_phrase_table USING bm25 (id, flavour)
    WITH (
    key_field = 'id',
    text_fields = '{
            "flavour": {
                "tokenizer": {"type": "default"}
            }
        }'
    );

SELECT flavour FROM test_phrase_table
WHERE id @@@ '{
        "phrase": {
            "field": "flavour",
            "phrases": ["apple", "BANANA"],
            "slop": 2
        }
    }'::jsonb ORDER BY id;

drop table if exists test_phrase_table cascade;