-- Test that ISOK_RESULTS rows go away when they are no longer returned
-- (absent a Keep_Until value)

BEGIN;

-- Run once to populate ISOK_RESULTS
SELECT irid, iqname, qr_id, qr_message, qr_extra
  FROM run_isok_queries($$VALUES ('query1');$$)
  ORDER BY irid;

-- Update the query to change the list of results
UPDATE isok_queries
  SET query = $$VALUES ('R2', 'Result number 2', NULL);$$
  WHERE iqname = 'query1';

-- Run again to update ISOK_RESULTS
-- See that only R2 is left
SELECT irid, iqname, qr_id, qr_message, qr_extra
  FROM run_isok_queries($$VALUES ('query1');$$)
  ORDER BY irid;

ROLLBACK;


-- Cleanup

-- Reset the sequence so what this test did is ignored.
SELECT setval('isok_results_irid_seq', 1, FALSE);
