-- Test that ISOK_QUERIES.Keep puts 'infinity' in the ISOK_RESULTS.keep_util
-- column.

BEGIN;

-- Set all the keep flags
UPDATE isok_queries
  SET keep = true;

-- Examine what happens
-- Exclude all the 'infinity' results, so we should get no rows.
SELECT *
  FROM run_isok_queries() AS riq
  WHERE riq.keep_until IS DISTINCT FROM 'infinity';

ROLLBACK;


-- Cleanup

-- Reset the sequence so what this test did is ignored.
SELECT setval('isok_results_irid_seq', 1, FALSE);
