-- Running the query for a second time does not touch
-- the ISOK_RESULTS.First_Seen column but does update the
-- Last_Seen timestamp to the CURRENT_TIMESTAMP.
-- Be sure this new value is reflected in the ISOK_RESULTS table.

-- Run for the first time, outside of a transaction so
-- CURRENT_TIMESTAMP continues to update.
SELECT 1  FROM run_isok_queries() AS riq;

-- Wait, because our timestamps have a 1 second precision.
SELECT pg_sleep(1.5);

-- Examine what happens when we run again.
BEGIN;

SELECT 1  FROM run_isok_queries() AS riq;

-- Show unexpected *_Seen timestamp values.
-- (All should return 0 rows.)
SELECT *
  FROM isok_results
  WHERE isok_results.first_seen = CURRENT_TIMESTAMP::TIMESTAMP(0);

SELECT *
  FROM isok_results
  WHERE isok_results.last_seen <> CURRENT_TIMESTAMP::TIMESTAMP(0);

SELECT *
  FROM isok_results
  WHERE isok_results.last_seen <= isok_results.first_seen;

ROLLBACK;

-- Cleanup

-- Delete all the ISOK_RESULTS rows.
DELETE FROM isok_results;
-- Reset the sequence so what the previous tests did is ignored.
SELECT setval('isok_results_irid_seq', 1, FALSE);
