# pg_isok  A query centered monitoring tool for PostgreSQL
# Copyright (C) 2012, 2019, 2025 The Meme Factory, Inc.
#               http://www.karlpinc.com/
# Copyright (C) 2016, 2024 Jake Gordon, <jacob.gordon@duke.edu>
# Copyright (C) 2010, 2011, Karl O. Pinc <kop@karlpinc.com>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU Affero General Public License as published
#  by the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Affero General Public License for more details.
#
#  You should have received a copy of the GNU Affero General Public License
#  along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# Makefile for diagrams
#
# Karl O. Pinc <kop@karlpinc.com>


DIAGRAM_PATH := $(DOC_PATH)/diagrams
BUILT_DIAGRAM_PATH := $(BUILT_HTML_PATH)/diagrams


# Inkscape part
INKSCAPE_SOURCES := $(wildcard $(DIAGRAM_PATH)/*.svg)
INKSCAPE_PNG_TARGETS := \
    $(INKSCAPE_SOURCES:$(DIAGRAM_PATH)/%.svg=$(BUILT_DIAGRAM_PATH)/%.png)
INKSCAPE_TRANSPARENT_PNG_TARGETS := \
    $(INKSCAPE_SOURCES:$(DIAGRAM_PATH)/%.svg=$(BUILT_DIAGRAM_PATH)/%_trans.png)
INKSCAPE_SVG_TARGETS := \
    $(INKSCAPE_SOURCES:$(DIAGRAM_PATH)/%.svg=$(BUILT_DIAGRAM_PATH)/%.svg)

# Generic diagram targets
PNG_TARGETS := $(INKSCAPE_PNG_TARGETS) $(INKSCAPE_TRANSPARENT_PNG_TARGETS)
SVG_TARGETS := $(INKSCAPE_SVG_TARGETS)


# Where the diagrams are installed on the website
WEBSITE_DIAGRAMS_PATH = ../website/diagrams

MAKEDEPENDS_DIAGRAMS := $(MAKEDEPENDS)

DIAGRAM_TARGETS = $(PNG_TARGETS) $(SVG_TARGETS)

# Where the generated diagrams go
$(BUILT_DIAGRAM_PATH): | $(BUILT_HTML_PATH)
	mkdir -p $(BUILT_DIAGRAM_PATH)

#
# The graphics
#


##   png
##       Generate all PNGs
.PHONY: png
png: $(INKSCAPE_PNG_TARGETS)

##   svg
##       Generate all SVGs
.PHONY: svg
svg: $(INKSCAPE_SVG_TARGETS)


# Inkscape source

$(INKSCAPE_PNG_TARGETS): $(BUILT_DIAGRAM_PATH)/%.png: $(DIAGRAM_PATH)/%.svg \
                         $(MAKEDEPENDS_DIAGRAMS) \
                         | $(BUILT_DIAGRAM_PATH)
	inkscape --export-filename=$@ --export-background=white \
                 --export-dpi=600 $<

$(INKSCAPE_TRANSPARENT_PNG_TARGETS): $(BUILT_DIAGRAM_PATH)/%_trans.png \
                                     : $(DIAGRAM_PATH)/%.svg \
                                     $(MAKEDEPENDS_DIAGRAMS) \
                                     | $(BUILT_DIAGRAM_PATH)
	inkscape --export-filename=$@ --export-background-opacity=0 \
	         --export-dpi=600 $<

$(INKSCAPE_SVG_TARGETS): $(BUILT_DIAGRAM_PATH)/%.svg \
                         : $(DIAGRAM_PATH)/%.svg \
                         $(MAKEDEPENDS_DIAGRAMS) \
                         | $(BUILT_DIAGRAM_PATH)
	inkscape --export-filename=$@ $<
