dnl pg_isok  A query centered monitoring tool for PostgreSQL
dnl Copyright (C) 2025 The Meme Factory, Inc., http://www.karlpinc.com/
dnl
dnl  This program is free software: you can redistribute it and/or modify
dnl  it under the terms of the GNU Affero General Public License as published
dnl  by the Free Software Foundation, either version 3 of the License, or
dnl  (at your option) any later version.
dnl
dnl  This program is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl  GNU Affero General Public License for more details.
dnl
dnl  You should have received a copy of the GNU Affero General Public License
dnl  along with this program.  If not, see <https://www.gnu.org/licenses/>.
dnl
dnl Karl O. Pinc <kop@karlpinc.com>
dnl
dnl Inside comment text, compress multiple runs of whitespace into a
dnl single space.  Then, fold into lines.
dnl
dnl Remarks:
dnl   Requires gawk, not awk.  Could use perl, but this is done.  And
dnl   the result is distributed, so gawk is not required for
dnl   installation.  Anybody using the git repo and building entirely
dnl   from source must install so much stuff anyway that installing gawk
dnl   is trivial.
dnl
dnl   Dependent upon gawk because it takes a regex as the record separator
dnl   (the RS variable).
dnl
dnl Bugs:
dnl   Awk always ends by printing the output record separator, ORS.
dnl   So there's an extra SQL dollar-quote appended that must be removed.
dnl
dnl m4 includes
include(`commentmacros.m4')
dnl
# pg_isok  A query centered monitoring tool for PostgreSQL
# Copyright (C) 2025 The Meme Factory, Inc., http://www.karlpinc.com/
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU Affero General Public License as published
#  by the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Affero General Public License for more details.
#
#  You should have received a copy of the GNU Affero General Public License
#  along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# Karl O. Pinc <kop@karlpinc.com>

# DO NOT EDIT THIS FILE.  It was automatically generated.  Edit
# the *.m4 files instead.  (Files _should_ be re-created by
# typing 'make', with the appropriate target, at the command line.)

function fold(line,   words, word, fragment, len, i) {
  split(line, words, " ");
  fragment = "";
  len = 0;
  for (i in words) {
    word = words[i];
    if (len + length(word) + 1 > MAX_CHARS) {
      # The fragment is "full", output it
      if (len == 0) {
        # The word won't fit on a line
        printf "%s%s", word, "\n";
      } else {
        printf "%s%s", fragment, "\n";
        fragment = word;
        len = length(fragment)
      }
    } else {
      # Add the word to the fragment
      if (len == 0) {
        fragment = word;
        len = length(word);
      } else {
        fragment = fragment " " word;
        len += length(word) + 1;
      }
    }
  }
  if (len != 0)
    printf "%s", fragment;
}
BEGIN {
  # This works by splitting the text on the dollar quote used in the SQL,
  # to separate the comment text from everything else.
  RS = "isok_comment_delim_regex";
  ORS = "isok_comment_delim";
  MAX_CHARS = 50;
}
{
  half = NR/2;
  if (half == int(half)) {
    # Even numbered record.  These contain the text of the comment.
    # Replace whitespace runs with a single space.
    print fold(gensub(/([^;])[[:space:]][[:space:]]+/,"\\1 ","g"));
  } else {
    print $0;
  }
}
