-- The resolved results are updated, even when not output.
-- Check Last_Role

BEGIN;

-- Run query1 for the first time to get results
-- But don't show timestamps
SELECT irid, iqname, qr_id, qr_message, qr_extra
  FROM run_isok_queries($$VALUES ('query1')$$)
  ORDER BY irid;

-- Update the warnings so they are resolved.
UPDATE isok_results
  SET resolved = first_seen
  WHERE iqname = 'query1';

-- Update the query so that it sets a different role
UPDATE isok_queries
  SET role = 'isok_regression_testing_role'
  WHERE iqname = 'query1';

-- Create the role
-- Pretend it won't conflict with an existing role
CREATE ROLE isok_regression_testing_role NOLOGIN;

-- Create the schema
CREATE SCHEMA test_schema;

-- Examine what happens when we run again.
-- We should see no output
SELECT irid, iqname, qr_id, qr_message, qr_extra
  FROM run_isok_queries($$VALUES ('query1')$$);

-- But there should be an updated role in ISOK_RESULTS
-- Display something if the values have not changed
-- We should see no output
SELECT *
  FROM isok_results
  WHERE isok_results.last_role <> 'isok_regression_testing_role';

ROLLBACK;


-- Cleanup

-- Reset the sequence so what this test did is ignored.
SELECT setval('isok_results_irid_seq', 1, FALSE);
