<?xml version='1.0'?>
<xsl:stylesheet version='1.0'
                xmlns:xsl='http://www.w3.org/1999/XSL/Transform'
                xmlns:isok="http://karlpinc.com/isok">
  <isok:comment>
  Copyright (C) 2025 The Meme Factory, Inc.  https://karlpinc.com

     This program is free software: you can redistribute it and/or modify
     it under the terms of the GNU Affero General Public License as published
     by the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU Affero General Public License for more details.

     You should have received a copy of the GNU Affero General Public License
     along with this program.  If not, see https://www.gnu.org/licenses/.

    Karl O. Pinc kop@karlpinc.com

  There, that set it up so we can have comments.
  From: http://www.dpawson.co.uk/xsl/index.html
        http://www.dpawson.co.uk/xsl/sect2/comments.html#d2747e112

  If this were not "top level" we'd have to also have
  <xsl:fallback/>
  somewhere in here.

  The topmost 2 lines are basic and required Header Information.
  </isok:comment>
  <isok:comment>
    This stylesheet is used by the Makefile to generate SQL comments
    from the docbook text.

    Bugs:
    Instead of importing the docbook xsl and using it to process the
    content of the comment, we kludge it and assume there's only
    xref elements in the comment content.  Since we don't have
    a namespace for docbook4, this is how we know to do it.
  </isok:comment>

  <isok:comment>
    Establish m4 macros.
    Do this inside a comment, because the m4 macros tend to generate
    spurious whitespace.  And perhaps other content we don't want
    in our xsl.
    
  </isok:comment>

  <isok:comment>
    We want text output
  </isok:comment>
  <xsl:output method="text" />

  <isok:comment>
    Apply all the templates
  </isok:comment>
  <xsl:template match="*">
    <xsl:apply-templates />
  </xsl:template>

  <isok:comment>
    By default, do not output text nodes
  </isok:comment>
  <xsl:template match="text()" />


  <isok:comment>
    Output the xreflabel when that's what we want to see
    (get_xreflabel mode)
  </isok:comment>
  <xsl:template match="*" mode="get_xreflabel">
    <xsl:value-of select="@xreflabel" />
  </xsl:template>


  <isok:comment>
    Mode for processing comments
    (isok_comment mode)
  </isok:comment>

  <isok:comment>
    Output the xreflabel attribute value for xref elements
  </isok:comment>
  <xsl:template match="xref" mode="isok_comment">
    <xsl:apply-templates select="id(@linkend)" mode="get_xreflabel" />
  </xsl:template>

  <isok:comment>
    Do output text when we're in our special mode, otherwise ignore
    all elements and just get their text.
  </isok:comment>
  <xml:template match="text()" mode="isok_comment">
    <xml:value-of select="." />
  </xml:template>
  <xsl:template match="*" mode="isok_comment">
    <xsl:apply-templates mode="isok_comment"/>
  </xsl:template>

  <isok:comment>
    The table comments get the table name from
    the xreflabel attribute of the enclosing section.
  </isok:comment>
  <xsl:template match="*[@role='table_comment']">
    <xsl:text>COMMENT ON TABLE </xsl:text>
    <xsl:apply-templates select="ancestor::section[position()=1]"
                         mode="get_xreflabel"/>
    <xsl:text> IS&#10;$isok_comment$</xsl:text>
    <xsl:apply-templates mode="isok_comment" />
    <xsl:text>$isok_comment$;&#10;&#10;</xsl:text>
  </xsl:template>

  <isok:comment>
    The column comments get the column name from the xreflabel
    attribute of the enclosing section, and the table name from
    the xref attribute of that section's enclosing section.
  </isok:comment>
  <xsl:template match="*[@role='column_comment']">
    <xsl:text>COMMENT ON COLUMN </xsl:text>
    <xsl:apply-templates select="ancestor::section[position()=2]"
                         mode="get_xreflabel"/>
    <xsl:text>.</xsl:text>
    <xsl:apply-templates select="ancestor::section[position()=1]"
                         mode="get_xreflabel" />
    <xsl:text> IS&#10;$isok_comment$</xsl:text>
    <xsl:apply-templates mode="isok_comment" />
    <xsl:text>$isok_comment$;&#10;&#10;</xsl:text>
  </xsl:template>

</xsl:stylesheet>
