dnl pg_isok  A query centered monitoring tool for PostgreSQL
dnl Copyright (C) 2012, 2015, 2025 The Meme Factory, Inc.
dnl           http://www.karlpinc.com/
dnl
dnl  This program is free software: you can redistribute it and/or modify
dnl  it under the terms of the GNU Affero General Public License as published
dnl  by the Free Software Foundation, either version 3 of the License, or
dnl  (at your option) any later version.
dnl
dnl  This program is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl  GNU Affero General Public License for more details.
dnl
dnl  You should have received a copy of the GNU Affero General Public License
dnl  along with this program.  If not, see <https://www.gnu.org/licenses/>.
dnl
dnl Karl O. Pinc <kop@karlpinc.com>
dnl

dnl m4 includes
include(`copyright.m4')dnl
include(`triggermacros.m4')dnl

--  
-- isok_results
--

CREATE FUNCTION isok_results_func ()
  RETURNS trigger
  LANGUAGE plpgsql
  AS $$
  BEGIN
  -- Function for isok_results insert and update triggers
  --
  -- AGPL_notice(`  --', `2015, 2025',
                 `The Meme Factory, Inc., http://www.karlpinc.com/')

  IF TG_OP = 'UPDATE' THEN
    cannot_change(`@EXTSCHEMA@.ISOK_RESULTS', `IRID')
  END IF;

  -- Errors are not allowed to be resolved.
  IF NEW.resolved IS NOT NULL THEN
    PERFORM 1
      FROM @extschema@.isok_queries
      WHERE @extschema@.isok_queries.iqname = NEW.iqname
            AND @extschema@.isok_queries.error;
    IF FOUND THEN
      RAISE EXCEPTION integrity_constraint_violation USING
            MESSAGE = 'Error on ' || TG_OP || ' of ISOK_QUERIES'
          , DETAIL = 'Key (IRID) = (' || NEW.irid
                     || '): Value (IQName) = (' || NEW.iqname
                     || '): Value (QR_ID) = (' || NEW.qr_id
                     || '): Value (Resolved) = (' || NEW.resolved
                     || '): The INTEGRITY_QUERY ('
                     || NEW.iqname
                     || ') produces errors, these may not be marked resolved';
      RETURN NULL;
    END IF;
  END IF;

  RETURN NULL;
  END;
$$;


CREATE TRIGGER isok_results_trigger
  AFTER INSERT OR UPDATE
  ON isok_results FOR EACH ROW
  EXECUTE PROCEDURE isok_results_func();
