-- Test that the ISOK_RESULTS.Last_Schemas column is set from
-- ISOK_QUERIES.search_path.

BEGIN;

-- Create a query to run as the role
INSERT INTO isok_queries (
    iqname, error, type, keep
    -- , first_run, last_run
  , role, search_path, query, comment)
  VALUES('search_path_test'
       , false
       , 'type1'
       , false

       , NULL
       -- Use 'pg_catalog' because that's the SQL standard name
       -- for the "postgres" schema, and pg returns that name
       -- instead of 'postgres'.
       , 'pg_catalog,public'
       , $$VALUES ('R1', current_setting('search_path'), NULL);$$
       , 'No comment'
       );

-- When examining the result, we can't just show the Last_Schemas
-- array because it contains otherwise hidden schemas like the temporary
-- table schema.

-- Run the query
SELECT
    -- Does Last_Schemas contain the expected values?  (we want TRUE)
    '{"pg_catalog","public"}' <@ riq.last_schemas
    -- Does "pg_catalog" appear before "public"?  (we want TRUE)
  , array_position(riq.last_schemas, 'pg_catalog')
      < array_position(riq.last_schemas, 'public')
    -- Is this 'pg_catalog, public'?  (we want yes, it is)
  , riq.qr_message
  FROM run_isok_queries($$VALUES ('search_path_test');$$) AS riq;

ROLLBACK;


-- Cleanup

-- Reset the sequence so what this test did is ignored.
SELECT setval('isok_results_irid_seq', 1, FALSE);
