-- Test that the ISOK_QUERIES.Search_Path column sets the search path during
-- query execution.

BEGIN;

-- Create a query to run as the role
INSERT INTO isok_queries (
    iqname, error, type, keep
    -- , first_run, last_run
  , role, search_path, query, comment)
  VALUES('search_path_test'
       , false
       , 'type1'
       , false

       , NULL
       , 'imaginaryschema'
       , $$VALUES ('R1', current_setting('search_path'), NULL);$$
       , 'No comment'
       );

-- Run the query
SELECT riq.qr_message
  FROM run_isok_queries($$VALUES ('search_path_test');$$) AS riq;

-- And again in the ISOK_RESULTS table.
SELECT isok_results.qr_message
  FROM isok_results
  WHERE isok_results.iqname = 'search_path_test';

ROLLBACK;


-- Cleanup

-- Reset the sequence so what this test did is ignored.
SELECT setval('isok_results_irid_seq', 1, FALSE);
