-- Test that the ISOK_QUERIES.Role column sets the role during
-- query execution.

BEGIN;

-- Pretend that we're never going to have a collision with an existing
-- role on the cluster.
CREATE ROLE isok_regression_testing_role NOLOGIN;

-- Create a query to run as the role
INSERT INTO isok_queries (
    iqname, error, type, keep
    -- , first_run, last_run
  , role, search_path, query, comment)
  VALUES('role_test'
       , false
       , 'type1'
       , false

       , 'isok_regression_testing_role'
       , NULL
       , $$VALUES ('R1', current_user, NULL);$$
       , 'No comment'
       );

-- Run the query
-- We should see the isok_regression_testing_role as the message.
SELECT riq.qr_message
  FROM run_isok_queries($$VALUES ('role_test');$$) AS riq;

-- And again in the ISOK_RESULTS table.
SELECT isok_results.qr_message
  FROM isok_results
  WHERE isok_results.iqname = 'role_test';

ROLLBACK;


-- Cleanup

-- Reset the sequence so what this test did is ignored.
SELECT setval('isok_results_irid_seq', 1, FALSE);
