-- The results that are deferred to the future are omitted from the
-- function output

BEGIN;

-- Run for the first time to get results
SELECT 1  FROM run_isok_queries($$VALUES('query1')$$) AS riq;

-- Update the warnings so they are deferred.
UPDATE isok_results
  SET deferred_to = first_seen + '1 year'::INTERVAL;

-- Examine what happens when we run again.
-- We should get nothing.

SELECT * FROM run_isok_queries($$VALUES('query1')$$) AS riq;

ROLLBACK;


-- Cleanup

-- Reset the sequence so what this test did is ignored.
SELECT setval('isok_results_irid_seq', 1, FALSE);
