-- Test that the system reports a sensible error when the supplied
-- query is not a valid query.

-- This is something of a vanity test, because we already test
-- the exceptions.

BEGIN;

-- Update the query to something broken
UPDATE isok_queries
  SET query = $$bad sql;$$
  WHERE iqname = 'query1';

-- See that the error is trapped
SELECT *
  FROM run_isok_queries($$VALUES ('query1');$$)
  ORDER BY irid;

ROLLBACK;


-- Cleanup

-- Reset the sequence so what this test did is ignored.
SELECT setval('isok_results_irid_seq', 1, FALSE);
