-- Test that ISOK_RESULTS rows do not go away when they are no longer returned
-- when there is a Keep_Until value in the future

BEGIN;

-- Run once to populate ISOK_RESULTS
SELECT irid, iqname, qr_id, qr_message, qr_extra
  FROM run_isok_queries($$VALUES ('query1');$$)
  ORDER BY irid;

-- Keep the first result
UPDATE isok_results
  SET keep_until = 'infinity'
  WHERE iqname = 'query1'
        AND qr_id = 'R1';

-- Update the query to change the list of results
UPDATE isok_queries
  SET query = $$VALUES ('R2', 'Result number 2', NULL);$$
  WHERE iqname = 'query1';

-- Run again to update ISOK_RESULTS
-- See that only R1 and R2 are left
SELECT irid, iqname, qr_id, qr_message, qr_extra
  FROM run_isok_queries($$VALUES ('query1');$$)
  ORDER BY irid;

ROLLBACK;


-- Cleanup

-- Reset the sequence so what this test did is ignored.
SELECT setval('isok_results_irid_seq', 1, FALSE);
