dnl pg_isok  A query centered monitoring tool for PostgreSQL
dnl Copyright (C) 2012, 2015, 2025 The Meme Factory, Inc.
dnl           http://www.karlpinc.com/
dnl
dnl  This program is free software: you can redistribute it and/or modify
dnl  it under the terms of the GNU Affero General Public License as published
dnl  by the Free Software Foundation, either version 3 of the License, or
dnl  (at your option) any later version.
dnl
dnl  This program is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl  GNU Affero General Public License for more details.
dnl
dnl  You should have received a copy of the GNU Affero General Public License
dnl  along with this program.  If not, see <https://www.gnu.org/licenses/>.
dnl
dnl Karl O. Pinc <kop@karlpinc.com>
dnl

dnl m4 includes
include(`copyright.m4')dnl
include(`triggermacros.m4')dnl

--  
-- isok_queries
--

CREATE FUNCTION isok_queries_update_func ()
  RETURNS trigger
  LANGUAGE plpgsql
  AS $$
  BEGIN
  -- Function for isok_queries update triggers
  --
  -- AGPL_notice(`  --', `2015, 2025',
                 `The Meme Factory, Inc., http://www.karlpinc.com/')

  cannot_change(`@extschema@.ISOK_QUERIES', `IQName')

  IF OLD.error <> NEW.error AND NEW.error THEN
    PERFORM 1
      FROM @extschema@.isok_results
      WHERE @extschema@.isok_results.iqname = NEW.iqname
            AND @extschema@.isok_results.resolved IS NOT NULL;
    IF FOUND THEN
      RAISE EXCEPTION integrity_constraint_violation USING
            MESSAGE = 'Error on UPDATE of ISOK_QUERIES'
          , DETAIL = 'Key (IQName) = (' || NEW.iqname
                     || '): Value (Error) = (' || NEW.error
                     || '): Cannot make into an error when there are already'
                     || ' ISOK_RESULTS rows with a TRUE Resolved value';
      RETURN NULL;
    END IF;
  END IF;

  RETURN NULL;
  END;
$$;


CREATE TRIGGER isok_queries_update_trigger
  AFTER UPDATE
  ON isok_queries FOR EACH ROW
  EXECUTE PROCEDURE isok_queries_update_func();
