{
    "name": "pg_isok",
    "abstract": "Query based data integrity management",
    "version": "isok_version",
    "maintainer": "Karl O. Pinc <kop@karlpinc.com>",
    "license": {
        "agpl_3": "https://www.gnu.org/licenses/agpl-3.0.html"
    },
    "provides": {
        "pg_isok": {
            "abstract": "Query based data integrity management",
            "file": "sql/pg_isok--isok_version.sql",
            "docfile": "doc/index.html",
            "version": "isok_version"
        }
    },
    "description":
        "Isok can help you manage your data's integrity, especially when little technical effort can be spared, or manual review is involved, or data cleanup is done over time.  It is especially suited when importing \"dirty\" data into PostgreSQL for cleanup, and for corner cases where business logic is \"fuzzy\".  Isok can monitor anything that can be reported with an SQL query.  Unlike simply running a query, which reports the _existence_ of questionable data patterns, Isok produces reports alerting you of _changes_ to questionable data patterns, so that only new problems need be reviewed. To use Isok you write SQL queries, which produce reports alerting you of questionable data patterns. Then, on a row by row basis, you can defer, possibly forever, the appearance of individual alerts on future reports. Isok's expected usage targets data integrity maintenance and data cleanup.  Isok can be built as pure SQL, for installation in the cloud or other managed PostgreSQL instances.  It targets PostgreSQL 10 or later.",
    "tags": ["monitoring", "SQL", "query", "data cleanup", "soft errors",
             "alerts", "warnings", "data integrity", "data monitoring",
             "system monitoring", "suspicious content",
             "performance monitoring", "error checking", "errors",
             "data analysis", "cleanup", "isok", "is ok", "soft trigger"],
    "no_index": {
        "file": ["LICENSE", "Makefile", "META.json", "META.json.m4",
                 "pg_isok.control", "pg_isok.control.m4", "VERSION"],
        "directory": ["db", "doc_src", "make_files", "test"]
    },
    "prereqs": {
        "runtime": {
            "requires": {
                "PostgreSQL": ">= 10.0.0"
            }
        }
    },
    "resources": {
        "homepage": "https://kop.codeberg.page/pg_isok_docs/",
        "bugtracker": {
            "web": "https://codeberg.org/kop/pg_isok/issues",
            "mailto": "kop@karlpinc.com"
        },
        "repository": {
            "web": "https://codeberg.org/kop/pg_isok/",
            "url": "https://codeberg.org/kop/pg_isok.git",
            "type": "git"
        }
    },
    "release_status": "testing",
    "meta-spec": {
        "version": "1.0.0",
        "url": "https://pgxn.org/meta/spec.txt"
    }
}
