-- The results that are deferred to the current time are included in the
-- function output

BEGIN;

-- Run for the first time to get results
SELECT 1  FROM run_isok_queries($$VALUES('query1')$$) AS riq;

-- Update the warnings so they are deferred.
UPDATE isok_results
  SET deferred_to = CURRENT_TIMESTAMP;

-- Examine what happens when we run again.

-- Omit the role, search_path, and (non-NULL) timestamps from the
-- column list, they change and cause the test to fail.
-- We should get everything
SELECT irid, iqname, category
     , keep_until, qr_id, qr_message, qr_extra, notes
  FROM run_isok_queries($$VALUES('query1')$$) AS riq
  ORDER BY riq.irid;

ROLLBACK;


-- Cleanup

-- Reset the sequence so what this test did is ignored.
SELECT setval('isok_results_irid_seq', 1, FALSE);
