-- Running run_isok_queries() saves results in ISOK_RESULTS

BEGIN;

-- Omit the role, search_path, and (non-NULL) timestamps from the
-- column list, they change and cause the test to fail.

SELECT irid, iqname, deferred_to, category
     , keep_until, qr_id, qr_message, qr_extra, notes
  FROM run_isok_queries() AS riq
  ORDER BY riq.irid;
  
-- This output should look just like the above output, only with
-- a "resolved" column
SELECT irid, iqname, resolved, deferred_to, category
     , keep_until, qr_id, qr_message, qr_extra, notes
  FROM isok_results
  ORDER BY isok_results.irid;

ROLLBACK;


-- Cleanup

-- Reset the sequence so what this test did is ignored.
SELECT setval('isok_results_irid_seq', 1, FALSE);
