# pg_isok  A query centered monitoring tool for PostgreSQL
# Copyright (C) 2025 The Meme Factory, Inc., http://www.karlpinc.com/
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU Affero General Public License as published
#  by the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Affero General Public License for more details.
#
#  You should have received a copy of the GNU Affero General Public License
#  along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# Karl O. Pinc <kop@karlpinc.com>
#
# Makefile for generating SQL statements to attach comments to db objects.

COMMENTS_TARGETS := $(DB_PATH)/makecomments
GET_COMMENTS_TARGETS := $(DOC_PATH)/get_comments.xsl \
                        $(DB_PATH)/format_comments.gawk

# Build what we need to generate comments
$(DOC_PATH)/get_comments.xsl: $(DOC_PATH)/get_comments.xsl.m4 \
                              $(MAKEDEPENDS_DOC) \
                              $(MAKEDEPENDS_INCLUDES)
	m4 -I $(INCLUDE_PATH) $< > $@

$(DB_PATH)/format_comments.gawk: $(DB_PATH)/format_comments.gawk.m4 \
                                 $(MAKEDEPENDS_DB)
	m4 -I $(INCLUDE_PATH) $< > $@

#
# Extract the comments from the docs and build a complete file of
# comment SQL.
#

# Depending on xml validation of the main source doc makes sure that
# any changes to the docs are reflected in the comments.
#
# The "head" takes off the trailing dollar quote left by format_comments.gawk.
# We know this is on a line of it's own because get_comments.xsl always
# produces output that ends in a newline.
$(DB_PATH)/makecomments: $(DB_PATH)/makecomments.sql \
                             $(GET_COMMENTS_TARGETS) \
                             $(VALIDATE_PATH)/isok \
                             $(MAKEDEPENDS_DB)
	# Produce hand-written comments
	cp $< $@
	# Append to this the comments extracted from the documentation.
	$(XSLTPROC) $(DOC_PATH)/get_comments.xsl $(DOC_PATH)/isok.xml \
	  | gawk -f $(DB_PATH)/format_comments.gawk \
	  | head -n -1 \
	  >> $@

#
# Maintenance targets
#

.PHONY: maintainer-clean_comments
maintainer-clean_comments:
	rm -rf $(GET_COMMENTS_TARGETS) $(COMMENTS_TARGETS)

maintainer-clean: maintainer-clean_comments
