{
    "name": "pg_isok",
    "abstract": "A query centered monitoring tool",
    "version": "isok_version",
    "maintainer": "Karl O. Pinc <kop@karlpinc.com>",
    "license": {
        "agpl_3": "https://www.gnu.org/licenses/agpl-3.0.html"
    },
    "provides": {
        "pg_isok": {
            "abstract": "A query centered monitoring tool",
            "file": "sql/pg_isok--isok_version.sql",
            "docfile": "doc/pg_isok_html/isok.html",
            "version": "isok_version"
        }
    },
    "description":
        "Isok is for monitoring anything that can be reported with an SQL query.  It lets you run SQL to produce reports alerting you of suspicious or erroneous conditions, with features to suppress previously reported alerts.  Its expected usage targets data integrity maintenance and data cleanup.  It is especially suited for corner cases where business logic is \"fuzzy\" and database content is monitored for unusual but not prohibited content.  There is also a potential use-case for simplistic monitoring of PostgreSQL itself.  Isok can be built as pure SQL, for installation in managed PostgreSQL instances.  It targets PostgreSQL 10 or later.",
    "tags": ["monitoring", "SQL", "query", "data cleanup", "soft errors",
             "alerts", "warnings", "data integrity", "data monitoring",
             "system monitoring", "suspicious content",
             "performance monitoring", "error checking", "errors",
             "data analysis", "cleanup"],
    "no_index": {
        "file": ["LICENSE", "Makefile", "META.json", "META.json.m4",
                 "pg_isok.control", "pg_isok.control.m4", "VERSION"],
        "directory": ["db", "doc_src", "make_files", "test"]
    },
    "prereqs": {
        "runtime": {
            "requires": {
                "PostgreSQL": ">= 10.0.0"
            }
        }
    },
    "resources": {
        "homepage": "https://kop.codeberg.page/pg_isok_docs/",
        "bugtracker": {
            "web": "https://codeberg.org/kop/pg_isok/issues",
            "mailto": "kop@karlpinc.com"
        },
        "repository": {
            "web": "https://codeberg.org/kop/pg_isok/",
            "url": "https://codeberg.org/kop/pg_isok.git",
            "type": "git"
        }
    },
    "release_status": "unstable",
    "meta-spec": {
        "version": "1.0.0",
        "url": "https://pgxn.org/meta/spec.txt"
    }
}
