#pragma once

namespace clickhouse {

// based on https://github.com/ClickHouse/ClickHouse/blob/54ae88a859507722821624476c3818152f944055/src/Common/ErrorCodes.cpp
// (master on 28 Feb 2024)
enum ErrorCodes {
    OK = 0,
    UNSUPPORTED_METHOD = 1,
    UNSUPPORTED_PARAMETER = 2,
    UNEXPECTED_END_OF_FILE = 3,
    EXPECTED_END_OF_FILE = 4,
    CANNOT_PARSE_TEXT = 6,
    INCORRECT_NUMBER_OF_COLUMNS = 7,
    THERE_IS_NO_COLUMN = 8,
    SIZES_OF_COLUMNS_DOESNT_MATCH = 9,
    NOT_FOUND_COLUMN_IN_BLOCK = 10,
    POSITION_OUT_OF_BOUND = 11,
    PARAMETER_OUT_OF_BOUND = 12,
    SIZES_OF_COLUMNS_IN_TUPLE_DOESNT_MATCH = 13,
    DUPLICATE_COLUMN = 15,
    NO_SUCH_COLUMN_IN_TABLE = 16,
    SIZE_OF_FIXED_STRING_DOESNT_MATCH = 19,
    NUMBER_OF_COLUMNS_DOESNT_MATCH = 20,
    CANNOT_READ_FROM_ISTREAM = 23,
    CANNOT_WRITE_TO_OSTREAM = 24,
    CANNOT_PARSE_ESCAPE_SEQUENCE = 25,
    CANNOT_PARSE_QUOTED_STRING = 26,
    CANNOT_PARSE_INPUT_ASSERTION_FAILED = 27,
    CANNOT_PRINT_FLOAT_OR_DOUBLE_NUMBER = 28,
    ATTEMPT_TO_READ_AFTER_EOF = 32,
    CANNOT_READ_ALL_DATA = 33,
    TOO_MANY_ARGUMENTS_FOR_FUNCTION = 34,
    TOO_FEW_ARGUMENTS_FOR_FUNCTION = 35,
    BAD_ARGUMENTS = 36,
    UNKNOWN_ELEMENT_IN_AST = 37,
    CANNOT_PARSE_DATE = 38,
    TOO_LARGE_SIZE_COMPRESSED = 39,
    CHECKSUM_DOESNT_MATCH = 40,
    CANNOT_PARSE_DATETIME = 41,
    NUMBER_OF_ARGUMENTS_DOESNT_MATCH = 42,
    ILLEGAL_TYPE_OF_ARGUMENT = 43,
    ILLEGAL_COLUMN = 44,
    UNKNOWN_FUNCTION = 46,
    UNKNOWN_IDENTIFIER = 47,
    NOT_IMPLEMENTED = 48,
    LOGICAL_ERROR = 49,
    UNKNOWN_TYPE = 50,
    EMPTY_LIST_OF_COLUMNS_QUERIED = 51,
    COLUMN_QUERIED_MORE_THAN_ONCE = 52,
    TYPE_MISMATCH = 53,
    STORAGE_REQUIRES_PARAMETER = 55,
    UNKNOWN_STORAGE = 56,
    TABLE_ALREADY_EXISTS = 57,
    TABLE_METADATA_ALREADY_EXISTS = 58,
    ILLEGAL_TYPE_OF_COLUMN_FOR_FILTER = 59,
    UNKNOWN_TABLE = 60,
    SYNTAX_ERROR = 62,
    UNKNOWN_AGGREGATE_FUNCTION = 63,
    CANNOT_GET_SIZE_OF_FIELD = 68,
    ARGUMENT_OUT_OF_BOUND = 69,
    CANNOT_CONVERT_TYPE = 70,
    CANNOT_WRITE_AFTER_END_OF_BUFFER = 71,
    CANNOT_PARSE_NUMBER = 72,
    UNKNOWN_FORMAT = 73,
    CANNOT_READ_FROM_FILE_DESCRIPTOR = 74,
    CANNOT_WRITE_TO_FILE_DESCRIPTOR = 75,
    CANNOT_OPEN_FILE = 76,
    CANNOT_CLOSE_FILE = 77,
    UNKNOWN_TYPE_OF_QUERY = 78,
    INCORRECT_FILE_NAME = 79,
    INCORRECT_QUERY = 80,
    UNKNOWN_DATABASE = 81,
    DATABASE_ALREADY_EXISTS = 82,
    DIRECTORY_DOESNT_EXIST = 83,
    DIRECTORY_ALREADY_EXISTS = 84,
    FORMAT_IS_NOT_SUITABLE_FOR_INPUT = 85,
    RECEIVED_ERROR_FROM_REMOTE_IO_SERVER = 86,
    CANNOT_SEEK_THROUGH_FILE = 87,
    CANNOT_TRUNCATE_FILE = 88,
    UNKNOWN_COMPRESSION_METHOD = 89,
    EMPTY_LIST_OF_COLUMNS_PASSED = 90,
    SIZES_OF_MARKS_FILES_ARE_INCONSISTENT = 91,
    EMPTY_DATA_PASSED = 92,
    UNKNOWN_AGGREGATED_DATA_VARIANT = 93,
    CANNOT_MERGE_DIFFERENT_AGGREGATED_DATA_VARIANTS = 94,
    CANNOT_READ_FROM_SOCKET = 95,
    CANNOT_WRITE_TO_SOCKET = 96,
    UNKNOWN_PACKET_FROM_CLIENT = 99,
    UNKNOWN_PACKET_FROM_SERVER = 100,
    UNEXPECTED_PACKET_FROM_CLIENT = 101,
    UNEXPECTED_PACKET_FROM_SERVER = 102,
    TOO_SMALL_BUFFER_SIZE = 104,
    FILE_DOESNT_EXIST = 107,
    NO_DATA_TO_INSERT = 108,
    CANNOT_BLOCK_SIGNAL = 109,
    CANNOT_UNBLOCK_SIGNAL = 110,
    CANNOT_MANIPULATE_SIGSET = 111,
    CANNOT_WAIT_FOR_SIGNAL = 112,
    THERE_IS_NO_SESSION = 113,
    CANNOT_CLOCK_GETTIME = 114,
    UNKNOWN_SETTING = 115,
    THERE_IS_NO_DEFAULT_VALUE = 116,
    INCORRECT_DATA = 117,
    ENGINE_REQUIRED = 119,
    CANNOT_INSERT_VALUE_OF_DIFFERENT_SIZE_INTO_TUPLE = 120,
    UNSUPPORTED_JOIN_KEYS = 121,
    INCOMPATIBLE_COLUMNS = 122,
    UNKNOWN_TYPE_OF_AST_NODE = 123,
    INCORRECT_ELEMENT_OF_SET = 124,
    INCORRECT_RESULT_OF_SCALAR_SUBQUERY = 125,
    ILLEGAL_INDEX = 127,
    TOO_LARGE_ARRAY_SIZE = 128,
    FUNCTION_IS_SPECIAL = 129,
    CANNOT_READ_ARRAY_FROM_TEXT = 130,
    TOO_LARGE_STRING_SIZE = 131,
    AGGREGATE_FUNCTION_DOESNT_ALLOW_PARAMETERS = 133,
    PARAMETERS_TO_AGGREGATE_FUNCTIONS_MUST_BE_LITERALS = 134,
    ZERO_ARRAY_OR_TUPLE_INDEX = 135,
    UNKNOWN_ELEMENT_IN_CONFIG = 137,
    EXCESSIVE_ELEMENT_IN_CONFIG = 138,
    NO_ELEMENTS_IN_CONFIG = 139,
    SAMPLING_NOT_SUPPORTED = 141,
    NOT_FOUND_NODE = 142,
    UNKNOWN_OVERFLOW_MODE = 145,
    UNKNOWN_DIRECTION_OF_SORTING = 152,
    ILLEGAL_DIVISION = 153,
    DICTIONARIES_WAS_NOT_LOADED = 156,
    TOO_MANY_ROWS = 158,
    TIMEOUT_EXCEEDED = 159,
    TOO_SLOW = 160,
    TOO_MANY_COLUMNS = 161,
    TOO_DEEP_SUBQUERIES = 162,
    READONLY = 164,
    TOO_MANY_TEMPORARY_COLUMNS = 165,
    TOO_MANY_TEMPORARY_NON_CONST_COLUMNS = 166,
    TOO_DEEP_AST = 167,
    TOO_BIG_AST = 168,
    BAD_TYPE_OF_FIELD = 169,
    BAD_GET = 170,
    CANNOT_CREATE_DIRECTORY = 172,
    CANNOT_ALLOCATE_MEMORY = 173,
    CYCLIC_ALIASES = 174,
    MULTIPLE_EXPRESSIONS_FOR_ALIAS = 179,
    THERE_IS_NO_PROFILE = 180,
    ILLEGAL_FINAL = 181,
    ILLEGAL_PREWHERE = 182,
    UNEXPECTED_EXPRESSION = 183,
    ILLEGAL_AGGREGATION = 184,
    UNSUPPORTED_COLLATION_LOCALE = 186,
    COLLATION_COMPARISON_FAILED = 187,
    SIZES_OF_ARRAYS_DONT_MATCH = 190,
    SET_SIZE_LIMIT_EXCEEDED = 191,
    UNKNOWN_USER = 192,
    WRONG_PASSWORD = 193,
    REQUIRED_PASSWORD = 194,
    IP_ADDRESS_NOT_ALLOWED = 195,
    UNKNOWN_ADDRESS_PATTERN_TYPE = 196,
    DNS_ERROR = 198,
    UNKNOWN_QUOTA = 199,
    QUOTA_EXCEEDED = 201,
    TOO_MANY_SIMULTANEOUS_QUERIES = 202,
    NO_FREE_CONNECTION = 203,
    CANNOT_FSYNC = 204,
    ALIAS_REQUIRED = 206,
    AMBIGUOUS_IDENTIFIER = 207,
    EMPTY_NESTED_TABLE = 208,
    SOCKET_TIMEOUT = 209,
    NETWORK_ERROR = 210,
    EMPTY_QUERY = 211,
    UNKNOWN_LOAD_BALANCING = 212,
    UNKNOWN_TOTALS_MODE = 213,
    CANNOT_STATVFS = 214,
    NOT_AN_AGGREGATE = 215,
    QUERY_WITH_SAME_ID_IS_ALREADY_RUNNING = 216,
    CLIENT_HAS_CONNECTED_TO_WRONG_PORT = 217,
    TABLE_IS_DROPPED = 218,
    DATABASE_NOT_EMPTY = 219,
    DUPLICATE_INTERSERVER_IO_ENDPOINT = 220,
    NO_SUCH_INTERSERVER_IO_ENDPOINT = 221,
    UNEXPECTED_AST_STRUCTURE = 223,
    REPLICA_IS_ALREADY_ACTIVE = 224,
    NO_ZOOKEEPER = 225,
    NO_FILE_IN_DATA_PART = 226,
    UNEXPECTED_FILE_IN_DATA_PART = 227,
    BAD_SIZE_OF_FILE_IN_DATA_PART = 228,
    QUERY_IS_TOO_LARGE = 229,
    NOT_FOUND_EXPECTED_DATA_PART = 230,
    TOO_MANY_UNEXPECTED_DATA_PARTS = 231,
    NO_SUCH_DATA_PART = 232,
    BAD_DATA_PART_NAME = 233,
    NO_REPLICA_HAS_PART = 234,
    DUPLICATE_DATA_PART = 235,
    ABORTED = 236,
    NO_REPLICA_NAME_GIVEN = 237,
    FORMAT_VERSION_TOO_OLD = 238,
    CANNOT_MUNMAP = 239,
    CANNOT_MREMAP = 240,
    MEMORY_LIMIT_EXCEEDED = 241,
    TABLE_IS_READ_ONLY = 242,
    NOT_ENOUGH_SPACE = 243,
    UNEXPECTED_ZOOKEEPER_ERROR = 244,
    CORRUPTED_DATA = 246,
    INVALID_PARTITION_VALUE = 248,
    NO_SUCH_REPLICA = 251,
    TOO_MANY_PARTS = 252,
    REPLICA_ALREADY_EXISTS = 253,
    NO_ACTIVE_REPLICAS = 254,
    TOO_MANY_RETRIES_TO_FETCH_PARTS = 255,
    PARTITION_ALREADY_EXISTS = 256,
    PARTITION_DOESNT_EXIST = 257,
    UNION_ALL_RESULT_STRUCTURES_MISMATCH = 258,
    CLIENT_OUTPUT_FORMAT_SPECIFIED = 260,
    UNKNOWN_BLOCK_INFO_FIELD = 261,
    BAD_COLLATION = 262,
    CANNOT_COMPILE_CODE = 263,
    INCOMPATIBLE_TYPE_OF_JOIN = 264,
    NO_AVAILABLE_REPLICA = 265,
    MISMATCH_REPLICAS_DATA_SOURCES = 266,
    INFINITE_LOOP = 269,
    CANNOT_COMPRESS = 270,
    CANNOT_DECOMPRESS = 271,
    CANNOT_IO_SUBMIT = 272,
    CANNOT_IO_GETEVENTS = 273,
    AIO_READ_ERROR = 274,
    AIO_WRITE_ERROR = 275,
    INDEX_NOT_USED = 277,
    ALL_CONNECTION_TRIES_FAILED = 279,
    NO_AVAILABLE_DATA = 280,
    DICTIONARY_IS_EMPTY = 281,
    INCORRECT_INDEX = 282,
    UNKNOWN_DISTRIBUTED_PRODUCT_MODE = 283,
    WRONG_GLOBAL_SUBQUERY = 284,
    TOO_FEW_LIVE_REPLICAS = 285,
    UNSATISFIED_QUORUM_FOR_PREVIOUS_WRITE = 286,
    UNKNOWN_FORMAT_VERSION = 287,
    DISTRIBUTED_IN_JOIN_SUBQUERY_DENIED = 288,
    REPLICA_IS_NOT_IN_QUORUM = 289,
    LIMIT_EXCEEDED = 290,
    DATABASE_ACCESS_DENIED = 291,
    MONGODB_CANNOT_AUTHENTICATE = 293,
    RECEIVED_EMPTY_DATA = 295,
    SHARD_HAS_NO_CONNECTIONS = 297,
    CANNOT_PIPE = 298,
    CANNOT_FORK = 299,
    CANNOT_DLSYM = 300,
    CANNOT_CREATE_CHILD_PROCESS = 301,
    CHILD_WAS_NOT_EXITED_NORMALLY = 302,
    CANNOT_SELECT = 303,
    CANNOT_WAITPID = 304,
    TABLE_WAS_NOT_DROPPED = 305,
    TOO_DEEP_RECURSION = 306,
    TOO_MANY_BYTES = 307,
    UNEXPECTED_NODE_IN_ZOOKEEPER = 308,
    FUNCTION_CANNOT_HAVE_PARAMETERS = 309,
    INVALID_CONFIG_PARAMETER = 318,
    UNKNOWN_STATUS_OF_INSERT = 319,
    VALUE_IS_OUT_OF_RANGE_OF_DATA_TYPE = 321,
    UNKNOWN_DATABASE_ENGINE = 336,
    UNFINISHED = 341,
    METADATA_MISMATCH = 342,
    SUPPORT_IS_DISABLED = 344,
    TABLE_DIFFERS_TOO_MUCH = 345,
    CANNOT_CONVERT_CHARSET = 346,
    CANNOT_LOAD_CONFIG = 347,
    CANNOT_INSERT_NULL_IN_ORDINARY_COLUMN = 349,
    AMBIGUOUS_COLUMN_NAME = 352,
    INDEX_OF_POSITIONAL_ARGUMENT_IS_OUT_OF_RANGE = 353,
    ZLIB_INFLATE_FAILED = 354,
    ZLIB_DEFLATE_FAILED = 355,
    INTO_OUTFILE_NOT_ALLOWED = 358,
    TABLE_SIZE_EXCEEDS_MAX_DROP_SIZE_LIMIT = 359,
    CANNOT_CREATE_CHARSET_CONVERTER = 360,
    SEEK_POSITION_OUT_OF_BOUND = 361,
    CURRENT_WRITE_BUFFER_IS_EXHAUSTED = 362,
    CANNOT_CREATE_IO_BUFFER = 363,
    RECEIVED_ERROR_TOO_MANY_REQUESTS = 364,
    SIZES_OF_NESTED_COLUMNS_ARE_INCONSISTENT = 366,
    ALL_REPLICAS_ARE_STALE = 369,
    DATA_TYPE_CANNOT_BE_USED_IN_TABLES = 370,
    INCONSISTENT_CLUSTER_DEFINITION = 371,
    SESSION_NOT_FOUND = 372,
    SESSION_IS_LOCKED = 373,
    INVALID_SESSION_TIMEOUT = 374,
    CANNOT_DLOPEN = 375,
    CANNOT_PARSE_UUID = 376,
    ILLEGAL_SYNTAX_FOR_DATA_TYPE = 377,
    DATA_TYPE_CANNOT_HAVE_ARGUMENTS = 378,
    CANNOT_KILL = 380,
    HTTP_LENGTH_REQUIRED = 381,
    CANNOT_LOAD_CATBOOST_MODEL = 382,
    CANNOT_APPLY_CATBOOST_MODEL = 383,
    PART_IS_TEMPORARILY_LOCKED = 384,
    MULTIPLE_STREAMS_REQUIRED = 385,
    NO_COMMON_TYPE = 386,
    DICTIONARY_ALREADY_EXISTS = 387,
    CANNOT_ASSIGN_OPTIMIZE = 388,
    INSERT_WAS_DEDUPLICATED = 389,
    CANNOT_GET_CREATE_TABLE_QUERY = 390,
    EXTERNAL_LIBRARY_ERROR = 391,
    QUERY_IS_PROHIBITED = 392,
    THERE_IS_NO_QUERY = 393,
    QUERY_WAS_CANCELLED = 394,
    FUNCTION_THROW_IF_VALUE_IS_NON_ZERO = 395,
    TOO_MANY_ROWS_OR_BYTES = 396,
    QUERY_IS_NOT_SUPPORTED_IN_MATERIALIZED_VIEW = 397,
    UNKNOWN_MUTATION_COMMAND = 398,
    FORMAT_IS_NOT_SUITABLE_FOR_OUTPUT = 399,
    CANNOT_STAT = 400,
    FEATURE_IS_NOT_ENABLED_AT_BUILD_TIME = 401,
    CANNOT_IOSETUP = 402,
    INVALID_JOIN_ON_EXPRESSION = 403,
    BAD_ODBC_CONNECTION_STRING = 404,
    TOP_AND_LIMIT_TOGETHER = 406,
    DECIMAL_OVERFLOW = 407,
    BAD_REQUEST_PARAMETER = 408,
    EXTERNAL_SERVER_IS_NOT_RESPONDING = 410,
    PTHREAD_ERROR = 411,
    NETLINK_ERROR = 412,
    CANNOT_SET_SIGNAL_HANDLER = 413,
    ALL_REPLICAS_LOST = 415,
    REPLICA_STATUS_CHANGED = 416,
    EXPECTED_ALL_OR_ANY = 417,
    UNKNOWN_JOIN = 418,
    MULTIPLE_ASSIGNMENTS_TO_COLUMN = 419,
    CANNOT_UPDATE_COLUMN = 420,
    CANNOT_ADD_DIFFERENT_AGGREGATE_STATES = 421,
    UNSUPPORTED_URI_SCHEME = 422,
    CANNOT_GETTIMEOFDAY = 423,
    CANNOT_LINK = 424,
    SYSTEM_ERROR = 425,
    CANNOT_COMPILE_REGEXP = 427,
    FAILED_TO_GETPWUID = 429,
    MISMATCHING_USERS_FOR_PROCESS_AND_DATA = 430,
    ILLEGAL_SYNTAX_FOR_CODEC_TYPE = 431,
    UNKNOWN_CODEC = 432,
    ILLEGAL_CODEC_PARAMETER = 433,
    CANNOT_PARSE_PROTOBUF_SCHEMA = 434,
    NO_COLUMN_SERIALIZED_TO_REQUIRED_PROTOBUF_FIELD = 435,
    PROTOBUF_BAD_CAST = 436,
    PROTOBUF_FIELD_NOT_REPEATED = 437,
    DATA_TYPE_CANNOT_BE_PROMOTED = 438,
    CANNOT_SCHEDULE_TASK = 439,
    INVALID_LIMIT_EXPRESSION = 440,
    CANNOT_PARSE_DOMAIN_VALUE_FROM_STRING = 441,
    BAD_DATABASE_FOR_TEMPORARY_TABLE = 442,
    NO_COLUMNS_SERIALIZED_TO_PROTOBUF_FIELDS = 443,
    UNKNOWN_PROTOBUF_FORMAT = 444,
    CANNOT_MPROTECT = 445,
    FUNCTION_NOT_ALLOWED = 446,
    HYPERSCAN_CANNOT_SCAN_TEXT = 447,
    BROTLI_READ_FAILED = 448,
    BROTLI_WRITE_FAILED = 449,
    BAD_TTL_EXPRESSION = 450,
    BAD_TTL_FILE = 451,
    SETTING_CONSTRAINT_VIOLATION = 452,
    MYSQL_CLIENT_INSUFFICIENT_CAPABILITIES = 453,
    OPENSSL_ERROR = 454,
    SUSPICIOUS_TYPE_FOR_LOW_CARDINALITY = 455,
    UNKNOWN_QUERY_PARAMETER = 456,
    BAD_QUERY_PARAMETER = 457,
    CANNOT_UNLINK = 458,
    CANNOT_SET_THREAD_PRIORITY = 459,
    CANNOT_CREATE_TIMER = 460,
    CANNOT_SET_TIMER_PERIOD = 461,
    CANNOT_FCNTL = 463,
    CANNOT_PARSE_ELF = 464,
    CANNOT_PARSE_DWARF = 465,
    INSECURE_PATH = 466,
    CANNOT_PARSE_BOOL = 467,
    CANNOT_PTHREAD_ATTR = 468,
    VIOLATED_CONSTRAINT = 469,
    QUERY_IS_NOT_SUPPORTED_IN_LIVE_VIEW = 470,
    INVALID_SETTING_VALUE = 471,
    READONLY_SETTING = 472,
    DEADLOCK_AVOIDED = 473,
    INVALID_TEMPLATE_FORMAT = 474,
    INVALID_WITH_FILL_EXPRESSION = 475,
    WITH_TIES_WITHOUT_ORDER_BY = 476,
    INVALID_USAGE_OF_INPUT = 477,
    UNKNOWN_POLICY = 478,
    UNKNOWN_DISK = 479,
    UNKNOWN_PROTOCOL = 480,
    PATH_ACCESS_DENIED = 481,
    DICTIONARY_ACCESS_DENIED = 482,
    TOO_MANY_REDIRECTS = 483,
    INTERNAL_REDIS_ERROR = 484,
    CANNOT_GET_CREATE_DICTIONARY_QUERY = 487,
    INCORRECT_DICTIONARY_DEFINITION = 489,
    CANNOT_FORMAT_DATETIME = 490,
    UNACCEPTABLE_URL = 491,
    ACCESS_ENTITY_NOT_FOUND = 492,
    ACCESS_ENTITY_ALREADY_EXISTS = 493,
    ACCESS_STORAGE_READONLY = 495,
    QUOTA_REQUIRES_CLIENT_KEY = 496,
    ACCESS_DENIED = 497,
    LIMIT_BY_WITH_TIES_IS_NOT_SUPPORTED = 498,
    S3_ERROR = 499,
    AZURE_BLOB_STORAGE_ERROR = 500,
    CANNOT_CREATE_DATABASE = 501,
    CANNOT_SIGQUEUE = 502,
    AGGREGATE_FUNCTION_THROW = 503,
    FILE_ALREADY_EXISTS = 504,
    UNABLE_TO_SKIP_UNUSED_SHARDS = 507,
    UNKNOWN_ACCESS_TYPE = 508,
    INVALID_GRANT = 509,
    CACHE_DICTIONARY_UPDATE_FAIL = 510,
    UNKNOWN_ROLE = 511,
    SET_NON_GRANTED_ROLE = 512,
    UNKNOWN_PART_TYPE = 513,
    ACCESS_STORAGE_FOR_INSERTION_NOT_FOUND = 514,
    INCORRECT_ACCESS_ENTITY_DEFINITION = 515,
    AUTHENTICATION_FAILED = 516,
    CANNOT_ASSIGN_ALTER = 517,
    CANNOT_COMMIT_OFFSET = 518,
    NO_REMOTE_SHARD_AVAILABLE = 519,
    CANNOT_DETACH_DICTIONARY_AS_TABLE = 520,
    ATOMIC_RENAME_FAIL = 521,
    UNKNOWN_ROW_POLICY = 523,
    ALTER_OF_COLUMN_IS_FORBIDDEN = 524,
    INCORRECT_DISK_INDEX = 525,
    NO_SUITABLE_FUNCTION_IMPLEMENTATION = 527,
    CASSANDRA_INTERNAL_ERROR = 528,
    NOT_A_LEADER = 529,
    CANNOT_CONNECT_RABBITMQ = 530,
    CANNOT_FSTAT = 531,
    LDAP_ERROR = 532,
    UNKNOWN_RAID_TYPE = 535,
    CANNOT_RESTORE_FROM_FIELD_DUMP = 536,
    ILLEGAL_MYSQL_VARIABLE = 537,
    MYSQL_SYNTAX_ERROR = 538,
    CANNOT_BIND_RABBITMQ_EXCHANGE = 539,
    CANNOT_DECLARE_RABBITMQ_EXCHANGE = 540,
    CANNOT_CREATE_RABBITMQ_QUEUE_BINDING = 541,
    CANNOT_REMOVE_RABBITMQ_EXCHANGE = 542,
    UNKNOWN_MYSQL_DATATYPES_SUPPORT_LEVEL = 543,
    ROW_AND_ROWS_TOGETHER = 544,
    FIRST_AND_NEXT_TOGETHER = 545,
    NO_ROW_DELIMITER = 546,
    INVALID_RAID_TYPE = 547,
    UNKNOWN_VOLUME = 548,
    DATA_TYPE_CANNOT_BE_USED_IN_KEY = 549,
    UNRECOGNIZED_ARGUMENTS = 552,
    LZMA_STREAM_ENCODER_FAILED = 553,
    LZMA_STREAM_DECODER_FAILED = 554,
    ROCKSDB_ERROR = 555,
    SYNC_MYSQL_USER_ACCESS_ERROR = 556,
    UNKNOWN_UNION = 557,
    EXPECTED_ALL_OR_DISTINCT = 558,
    INVALID_GRPC_QUERY_INFO = 559,
    ZSTD_ENCODER_FAILED = 560,
    ZSTD_DECODER_FAILED = 561,
    TLD_LIST_NOT_FOUND = 562,
    CANNOT_READ_MAP_FROM_TEXT = 563,
    INTERSERVER_SCHEME_DOESNT_MATCH = 564,
    TOO_MANY_PARTITIONS = 565,
    CANNOT_RMDIR = 566,
    DUPLICATED_PART_UUIDS = 567,
    RAFT_ERROR = 568,
    MULTIPLE_COLUMNS_SERIALIZED_TO_SAME_PROTOBUF_FIELD = 569,
    DATA_TYPE_INCOMPATIBLE_WITH_PROTOBUF_FIELD = 570,
    DATABASE_REPLICATION_FAILED = 571,
    TOO_MANY_QUERY_PLAN_OPTIMIZATIONS = 572,
    EPOLL_ERROR = 573,
    DISTRIBUTED_TOO_MANY_PENDING_BYTES = 574,
    UNKNOWN_SNAPSHOT = 575,
    KERBEROS_ERROR = 576,
    INVALID_SHARD_ID = 577,
    INVALID_FORMAT_INSERT_QUERY_WITH_DATA = 578,
    INCORRECT_PART_TYPE = 579,
    CANNOT_SET_ROUNDING_MODE = 580,
    TOO_LARGE_DISTRIBUTED_DEPTH = 581,
    NO_SUCH_PROJECTION_IN_TABLE = 582,
    ILLEGAL_PROJECTION = 583,
    PROJECTION_NOT_USED = 584,
    CANNOT_PARSE_YAML = 585,
    CANNOT_CREATE_FILE = 586,
    CONCURRENT_ACCESS_NOT_SUPPORTED = 587,
    DISTRIBUTED_BROKEN_BATCH_INFO = 588,
    DISTRIBUTED_BROKEN_BATCH_FILES = 589,
    CANNOT_SYSCONF = 590,
    SQLITE_ENGINE_ERROR = 591,
    DATA_ENCRYPTION_ERROR = 592,
    ZERO_COPY_REPLICATION_ERROR = 593,
    BZIP2_STREAM_DECODER_FAILED = 594,
    BZIP2_STREAM_ENCODER_FAILED = 595,
    INTERSECT_OR_EXCEPT_RESULT_STRUCTURES_MISMATCH = 596,
    NO_SUCH_ERROR_CODE = 597,
    BACKUP_ALREADY_EXISTS = 598,
    BACKUP_NOT_FOUND = 599,
    BACKUP_VERSION_NOT_SUPPORTED = 600,
    BACKUP_DAMAGED = 601,
    NO_BASE_BACKUP = 602,
    WRONG_BASE_BACKUP = 603,
    BACKUP_ENTRY_ALREADY_EXISTS = 604,
    BACKUP_ENTRY_NOT_FOUND = 605,
    BACKUP_IS_EMPTY = 606,
    CANNOT_RESTORE_DATABASE = 607,
    CANNOT_RESTORE_TABLE = 608,
    FUNCTION_ALREADY_EXISTS = 609,
    CANNOT_DROP_FUNCTION = 610,
    CANNOT_CREATE_RECURSIVE_FUNCTION = 611,
    POSTGRESQL_CONNECTION_FAILURE = 614,
    CANNOT_ADVISE = 615,
    UNKNOWN_READ_METHOD = 616,
    LZ4_ENCODER_FAILED = 617,
    LZ4_DECODER_FAILED = 618,
    POSTGRESQL_REPLICATION_INTERNAL_ERROR = 619,
    QUERY_NOT_ALLOWED = 620,
    CANNOT_NORMALIZE_STRING = 621,
    CANNOT_PARSE_CAPN_PROTO_SCHEMA = 622,
    CAPN_PROTO_BAD_CAST = 623,
    BAD_FILE_TYPE = 624,
    IO_SETUP_ERROR = 625,
    CANNOT_SKIP_UNKNOWN_FIELD = 626,
    BACKUP_ENGINE_NOT_FOUND = 627,
    OFFSET_FETCH_WITHOUT_ORDER_BY = 628,
    HTTP_RANGE_NOT_SATISFIABLE = 629,
    HAVE_DEPENDENT_OBJECTS = 630,
    UNKNOWN_FILE_SIZE = 631,
    UNEXPECTED_DATA_AFTER_PARSED_VALUE = 632,
    QUERY_IS_NOT_SUPPORTED_IN_WINDOW_VIEW = 633,
    MONGODB_ERROR = 634,
    CANNOT_POLL = 635,
    CANNOT_EXTRACT_TABLE_STRUCTURE = 636,
    INVALID_TABLE_OVERRIDE = 637,
    SNAPPY_UNCOMPRESS_FAILED = 638,
    SNAPPY_COMPRESS_FAILED = 639,
    NO_HIVEMETASTORE = 640,
    CANNOT_APPEND_TO_FILE = 641,
    CANNOT_PACK_ARCHIVE = 642,
    CANNOT_UNPACK_ARCHIVE = 643,
    NUMBER_OF_DIMENSIONS_MISMATCHED = 645,
    CANNOT_BACKUP_TABLE = 647,
    WRONG_DDL_RENAMING_SETTINGS = 648,
    INVALID_TRANSACTION = 649,
    SERIALIZATION_ERROR = 650,
    CAPN_PROTO_BAD_TYPE = 651,
    ONLY_NULLS_WHILE_READING_SCHEMA = 652,
    CANNOT_PARSE_BACKUP_SETTINGS = 653,
    WRONG_BACKUP_SETTINGS = 654,
    FAILED_TO_SYNC_BACKUP_OR_RESTORE = 655,
    UNKNOWN_STATUS_OF_TRANSACTION = 659,
    HDFS_ERROR = 660,
    CANNOT_SEND_SIGNAL = 661,
    FS_METADATA_ERROR = 662,
    INCONSISTENT_METADATA_FOR_BACKUP = 663,
    ACCESS_STORAGE_DOESNT_ALLOW_BACKUP = 664,
    CANNOT_CONNECT_NATS = 665,
    NOT_INITIALIZED = 667,
    INVALID_STATE = 668,
    NAMED_COLLECTION_DOESNT_EXIST = 669,
    NAMED_COLLECTION_ALREADY_EXISTS = 670,
    NAMED_COLLECTION_IS_IMMUTABLE = 671,
    INVALID_SCHEDULER_NODE = 672,
    RESOURCE_ACCESS_DENIED = 673,
    RESOURCE_NOT_FOUND = 674,
    CANNOT_PARSE_IPV4 = 675,
    CANNOT_PARSE_IPV6 = 676,
    THREAD_WAS_CANCELED = 677,
    IO_URING_INIT_FAILED = 678,
    IO_URING_SUBMIT_ERROR = 679,
    MIXED_ACCESS_PARAMETER_TYPES = 690,
    UNKNOWN_ELEMENT_OF_ENUM = 691,
    TOO_MANY_MUTATIONS = 692,
    AWS_ERROR = 693,
    ASYNC_LOAD_CYCLE = 694,
    ASYNC_LOAD_FAILED = 695,
    ASYNC_LOAD_CANCELED = 696,
    CANNOT_RESTORE_TO_NONENCRYPTED_DISK = 697,
    INVALID_REDIS_STORAGE_TYPE = 698,
    INVALID_REDIS_TABLE_STRUCTURE = 699,
    USER_SESSION_LIMIT_EXCEEDED = 700,
    CLUSTER_DOESNT_EXIST = 701,
    CLIENT_INFO_DOES_NOT_MATCH = 702,
    INVALID_IDENTIFIER = 703,
    QUERY_CACHE_USED_WITH_NONDETERMINISTIC_FUNCTIONS = 704,
    // TABLE_NOT_EMPTY = 705,
    // LIBSSH_ERROR = 706,
    // GCP_ERROR = 707,
    // ILLEGAL_STATISTIC = 708,
    // CANNOT_GET_REPLICATED_DATABASE_SNAPSHOT = 709,
    // FAULT_INJECTED = 710,
    // FILECACHE_ACCESS_DENIED = 711,
    // TOO_MANY_MATERIALIZED_VIEWS = 712,
    // UNEXPECTED_CLUSTER = 714,
    // CANNOT_DETECT_FORMAT = 715,
    // CANNOT_FORGET_PARTITION = 716,
    KEEPER_EXCEPTION = 999,
    POCO_EXCEPTION = 1000,
    STD_EXCEPTION = 1001,
    UNKNOWN_EXCEPTION = 1002,
};

}
